// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
|==========||==========|
GS Shader 2.1

By Goldshadow12
|==========||==========|
*/

#include "vertexVersionCentroidUV.h"

#include "uniformWorldConstants.h"

attribute POS4 POSITION;
attribute vec2 TEXCOORD_0;

out highp vec3 position;
out highp vec3 wPos;

void main() {
    
    POS4 pos = POSITION;

    mat2 rotate = mat2(cos(0.75),sin(0.75),-sin(0.75),cos(0.75));
    pos.xz *= rotate;
    pos.y += 0.8;
position.xyz = POSITION.xyz;
    POS4 worldPos = WORLDVIEWPROJ * POSITION;
    gl_Position = WORLDVIEWPROJ * pos;
   
    wPos = worldPos.xyz;
    
    position.xyz = POSITION.xyz;

    uv = TEXCOORD_0;
}